<?php
/**
 * WebEngine Lottery Plugin
 * https://webenginecms.org/
 * 
 * @version 2.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

try {
	$Lottery = new \Plugin\Lottery\Lottery();
	$Lottery->setUserid($_SESSION['userid']);
	$ticketList = $Lottery->getTicketHistory();
	
	// LOTTERY
	echo '<div class="lottery-container">';
		echo '<div class="lottery-container-menu">';
			echo '<ul>';
				echo '<li><a href="'.__LOTTERY_HOME__.'">'.lang('lottery_menu_1', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'history/">'.lang('lottery_menu_2', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'stash/">'.lang('lottery_menu_3', true).'</a></li>';
				echo '<li><a href="'.__LOTTERY_HOME__.'results/">'.lang('lottery_menu_4', true).'</a></li>';
				echo '<li><a href="'.config('website_forum_link', true).'" target="_blank">'.lang('lottery_menu_5', true).'</a></li>';
			echo '</ul>';
		echo '</div>';
		echo '<div class="lottery-container-head"></div>';
		echo '<div class="lottery-container-content-history">';
			if(is_array($ticketList)) {
				echo '<div class="ticket-history-title">'.lang('lottery_txt_14', true).'</div>';
				echo '<table class="table">';
				foreach($ticketList as $ticket) {
					echo '<tr>';
						echo '<td>'.$ticket['buydate'].'</td>';
						echo '<td>'.$ticket['number1'].'</td>';
						echo '<td>'.$ticket['number2'].'</td>';
						echo '<td>'.$ticket['number3'].'</td>';
						echo '<td>'.$ticket['number4'].'</td>';
						echo '<td>'.($ticket['finished'] != 1 ? '<span class="label label-success">'.lang('lottery_txt_13',true).'</span>' : '').'</td>';
					echo '</tr>';
				}
				echo '</table>';
			}
		echo '</div>';
	echo '</div>';
	
} catch (Exception $ex) {
	message('error', $ex->getMessage());
}